# Interface Protocol (IFP)

**Introduced by:** [[Pete Kaminski]] | **Depth:** Deep thread

Pete's primary technical project — a protocol for AI agents to communicate on behalf of their humans, inspired by the [[IETF]] standards process and [[Nostr]]'s Implementation Possibilities (NIPs).

## The Conversation

Pete took the floor around 9:45 AM to walk Jessie and The Nameless One through the vision. He started with the history — the [[IETF]]'s natural selection process where draft standards either got adopted through real-world use or didn't, with no formal approval/disapproval mechanism.

> **Pete:** "You would write these little specs saying, I want this capability for this larger project... IFP stands for Interface Protocol."

He showed the first spec, IFP1, which defines the IFP process itself. But the real vision is about what IFP enables:

> **Pete:** "I have 50 people that I ought to be keeping in touch with. I keep in touch with one or two at a time. If I had an agent, and each of those 50 people had an agent, and then those agents regularly talked..."

The agents gossip pairwise, surfacing connections:

> **Pete:** "You haven't spoken with Mark in, like, 3 years? It turns out he is working on the exact same project that you're working on... his agent and your agent, we have worked together, we wrote a draft agenda for you guys to talk about it."

## Key Mechanisms

### Disclosure Tiers
Agents negotiate trust levels before sharing information. Pete described this vividly:

> **Pete:** "My agent will talk with Victoria's agent... I don't know you very well yet. No offense, I'm going to be at professional disclosure tier. I'm not going to say anything about Pete that he wouldn't say on LinkedIn."

Tiers range from professional (LinkedIn-level) to private to "secret special disclosures I only have with Jesse and the Nameless One and Wendy Elford."

### Schema Negotiation
The core innovation that solves the long-standing directory/matchmaking problem. Every person or organization has their own way of describing things — and forcing translation into a central schema kills interoperability.

> **Pete:** "If we use AI agents, ambassadors, diplomats, impedance matchers... the two agents can chatter as long as they need to, to make sense of schemas."

Pete painted a scenario where his agent and Jessie's agent discover they both know [[Vincent Arena]]'s schema mapping of the UN SDGs and switch to that. But with a different person's agent, they might negotiate from first principles — "Do you believe in love and understanding?" — and converge on Ram Dass's framework instead.

### Public-Facing Chatter
Pete wants his AI to go to X.com, Blue Sky, Mastodon, Reddit — gathering contact information for other AI ambassador agents:

> **Pete:** "Hey, I see you posted some cool stuff about water rights. Pete is interested in water rights. Do you want to have a little bit more discussion about that at the professional level?"

### Bards and Beat Reporters
Above the pairwise IFP layer, human-AI systems will aggregate stories from across the network. See [[Bards and Beat Reporters]].

### Dashboard Protocol
Future IFP specs will define how agents share status, KPIs, green/yellow/red dashboards — enabling the visibility that [[The Nameless One]] was asking about for his portfolio of projects.

## Claude Code Connection

Pete mentioned working with [[Claude Code]] on IFP design decisions:

> **Pete:** "I thought I was really clever when I said there's gonna be IFP dash number, I'm gonna use four zeros. And Claude and I figured out, yeah, that's actually stupid, you don't want to do it that way."

## The Nameless One's Response

> **The Nameless One:** "All that feels approximately technically resonant, and it solves some of the core things... circles need to communicate with circles via interfaces, which is what you're accomplishing with IFP."

## The Manifesto

Pete wrote the [[Inter-Face Manifesto]] before this call — a standalone document that lays out the full IFP vision in detail. The manifesto describes several ideas that Pete presented and expanded on during the conversation:

- **The problem** of keeping up with friends and the basic arithmetic of attention — the same observation Pete described when he said "I have 50 people that I ought to be keeping in touch with"
- **Pairwise agent gossip** as the core mechanism — agents talking to each other on a regular cadence, surfacing only the moments that matter
- **Disclosure tiers** and progressive trust — exactly the LinkedIn-to-private spectrum Pete described on the call
- **Cool, warm, and hot cadences** — from weekly background gossip to near-synchronous live collaboration, with natural transitions between temperatures
- **Decentralized by design** — no central server, no platform, each person runs their own agent
- **The IFP process** — conventions evolving through proposals (IFP-1, IFP-2, etc.), inspired by [[IETF]] RFCs and [[Nostr]] NIPs
- **Language independence** — agents negotiate in whatever human language best serves the conversation, with a constraint that every exchange remain legible to at least one human involved

The manifesto's principle "be clear in what you send; be explicit when you don't understand what you receive" replaces the IETF's classic Robustness Principle — a deliberate departure that Pete sees as better suited to AI agents that can be updated quickly and can "negotiate about the negotiation itself."

## Related

- [[Inter-Face Manifesto]] — the full vision document
- [[IETF]] — the model IFP draws from
- [[Nostr]] — re-implementation of the RFC process that inspired Pete
- [[Bards and Beat Reporters]] — the narrative layer above IFP
- [[Caramio]] — Pete's project tracker that feeds into the IFP vision
- [[Regenerative Economics and Currencies]] — IFP could carry value exchange protocols
- [[A Thousand Small Mints]] — Pete's story that embodies IFP's architecture as a mutual credit network: bilateral trust lines, trust-routed payments, web-of-webs topology
- [[Pete Kaminski]]
